/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.shared.world;

import de.hsw.mertcraft.shared.block.Block;
import de.hsw.mertcraft.shared.world.ChunkPos;
import de.hsw.mertcraft.shared.world.ChunkSection;
import de.hsw.mertcraft.shared.world.SectionPos;

public final class Chunk {
    public final int cx;
    public final int cz;
    private final ChunkSection[] sections;

    public Chunk(int cx, int cz) {
        this.cx = cx;
        this.cz = cz;
        this.sections = new ChunkSection[8];
    }

    public ChunkSection getSectionByWorldY(int wy) {
        return this.getSection(SectionPos.toSectionY(wy));
    }

    public ChunkSection getSection(int sy) {
        return this.sections[sy];
    }

    public ChunkSection getOrCreateSelection(int sy) {
        if (sy < 0 || sy >= this.sections.length) {
            return null;
        }
        ChunkSection section = this.sections[sy];
        if (section == null) {
            this.sections[sy] = section = new ChunkSection();
        }
        return section;
    }

    public short getBlock(int wx, int wy, int wz) {
        ChunkSection sec;
        int lx = ChunkPos.localX(wx);
        int lz = ChunkPos.localZ(wz);
        int sy = SectionPos.toSectionY(wy);
        int ly = wy - sy * 16;
        ChunkSection chunkSection = sec = sy >= 0 && sy < this.sections.length ? this.sections[sy] : null;
        if (sec == null) {
            return Block.AIR_PACKED;
        }
        return sec.get(lx, ly, lz);
    }

    public void setBlock(int wx, int wy, int wz, short packed) {
        if (wy < 0 || wy >= 128) {
            return;
        }
        int lx = ChunkPos.localX(wx);
        int lz = ChunkPos.localZ(wz);
        int sy = SectionPos.toSectionY(wy);
        int ly = wy - sy * 16;
        ChunkSection sec = this.sections[sy];
        if (sec == null) {
            if (Block.isAir(packed)) {
                return;
            }
            this.sections[sy] = sec = new ChunkSection();
        }
        sec.set(lx, ly, lz, packed);
        if (sec.isEmptyAir()) {
            this.sections[sy] = null;
        }
    }

    public boolean isEmptySection(int sy) {
        return this.sections[sy] == null;
    }
}

