/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.shared.serialize.impl;

import de.hsw.mertcraft.shared.serialize.BinaryIO;
import de.hsw.mertcraft.shared.serialize.ISerializer;
import java.nio.ByteBuffer;
import java.util.UUID;
import lombok.Generated;

public final class StandardSerializers {
    public static final ISerializer<String> STRING = new ISerializer<String>(){

        @Override
        public int getNecessarySize(String element) {
            return 1 + element.getBytes(BinaryIO.CHARSET).length;
        }

        @Override
        public void serialize(ByteBuffer buffer, String element) {
            byte[] bytes = element.getBytes(BinaryIO.CHARSET);
            buffer.put((byte)bytes.length);
            buffer.put(bytes);
        }

        @Override
        public String deserialize(ByteBuffer buffer) {
            byte[] bytes = new byte[buffer.get()];
            buffer.get(bytes);
            return new String(bytes);
        }
    };
    public static final ISerializer<UUID> UUID = new ISerializer<UUID>(){

        @Override
        public int getNecessarySize(UUID element) {
            return 16;
        }

        @Override
        public void serialize(ByteBuffer buffer, UUID element) {
            buffer.putLong(element.getMostSignificantBits());
            buffer.putLong(element.getLeastSignificantBits());
        }

        @Override
        public UUID deserialize(ByteBuffer buffer) {
            return new UUID(buffer.getLong(), buffer.getLong());
        }
    };

    @Generated
    private StandardSerializers() {
    }
}

