/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.shared.net.rpc;

import de.hsw.mertcraft.shared.log.Log;
import de.hsw.mertcraft.shared.net.NetConnection;
import de.hsw.mertcraft.shared.net.NetListener;
import de.hsw.mertcraft.shared.net.rpc.DelayedResponse;
import de.hsw.mertcraft.shared.net.rpc.RPCException;
import de.hsw.mertcraft.shared.net.rpc.RPCService;
import de.hsw.mertcraft.shared.serialize.BinarySerializer;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class RPCHandler
implements NetListener {
    static final byte OP_CALL = 0;
    static final byte OP_RESPONSE = 1;
    private final HashMap<Class, RPCService> classes = new HashMap();
    private final HashMap<Short, RPCService> register = new HashMap();
    private final HashMap<RPCService, Short> registerInvert = new HashMap();
    private short mask;

    public <I, O> void register(RPCService<I, O> service, short id) {
        this.register.put(id, service);
        this.registerInvert.put(service, id);
        this.classes.put(service.getClass(), service);
        service.init(this);
    }

    public <I, O> void register(RPCService<I, O> service) {
        while (this.register.containsKey(this.mask)) {
            this.mask = (short)(this.mask + 1 & 0xFFFF);
        }
        this.register(service, this.mask);
    }

    public <I, O> void setExecutor(Class<? extends RPCService<I, O>> clazz, RPCService.Executor<I, O> executor) {
        RPCService service = this.classes.get(clazz);
        if (service == null) {
            Log.error("RPCHandler", "Tried to set caller for " + clazz.getSimpleName() + " but the service isn't registered!");
            return;
        }
        service.setExecutor(executor);
    }

    public <I, O> void setAutoSubscription(Class<? extends RPCService<I, O>> clazz, DelayedResponse.Subscription<O> sub) {
        RPCService service = this.classes.get(clazz);
        if (service == null) {
            Log.error("RPCHandler", "Tried to set auto subscription for " + clazz.getSimpleName() + " but the service isn't registered!");
            return;
        }
        service.setAutoSubscription(sub);
    }

    public <I, O> RPCService<I, O> getByClass(Class<? extends RPCService<I, O>> clazz) {
        return this.classes.get(clazz);
    }

    void handleRemote(NetConnection target, RPCService service, byte op, long id, Object param) {
        if (!this.registerInvert.containsKey(service)) {
            throw new RPCException("Service is not registered!");
        }
        short mask = this.registerInvert.get(service);
        int payloadSize = BinarySerializer.getNeededSize(param, true);
        ByteBuffer out = ByteBuffer.allocate(11 + payloadSize);
        out.putShort(mask);
        out.put(op);
        out.putLong(id);
        BinarySerializer.serialize(param, out);
        target.send(out);
    }

    @Override
    public void onReceive(NetConnection connection, ByteBuffer data) {
        if (data.position() > 0) {
            data.flip();
        }
        short mask = data.getShort();
        RPCService service = this.register.get(mask);
        boolean receive = data.get() == 1;
        long transactionId = data.getLong();
        Object params = BinarySerializer.deserializeFlipped(data);
        if (receive) {
            service.receive(transactionId, params);
        } else {
            DelayedResponse deliver = service.execute(connection, params);
            if (deliver == null) {
                return;
            }
            this.handleRemote(connection, service, (byte)1, transactionId, deliver.getValue());
        }
    }

    @Override
    public void onConnect(NetConnection connection) {
    }

    @Override
    public void onDisconnect(NetConnection connection) {
    }
}

