/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.shared.net.packet.server;

import de.hsw.mertcraft.shared.serialize.ISerializer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import lombok.Generated;

public class ServerSendChunkSectionPacket {
    public int cx;
    public int cz;
    public int sy;
    public short[] blocks;
    public boolean isAllAir;

    @Generated
    public ServerSendChunkSectionPacket(int cx, int cz, int sy, short[] blocks, boolean isAllAir) {
        this.cx = cx;
        this.cz = cz;
        this.sy = sy;
        this.blocks = blocks;
        this.isAllAir = isAllAir;
    }

    @Generated
    public String toString() {
        return "ServerSendChunkSectionPacket(cx=" + this.cx + ", cz=" + this.cz + ", sy=" + this.sy + ", blocks=" + Arrays.toString(this.blocks) + ", isAllAir=" + this.isAllAir + ")";
    }

    public static final class Serializer
    implements ISerializer<ServerSendChunkSectionPacket> {
        @Override
        public int getNecessarySize(ServerSendChunkSectionPacket element) {
            int size = 13;
            if (!element.isAllAir) {
                size += element.blocks.length * 2;
            }
            return size;
        }

        @Override
        public void serialize(ByteBuffer buffer, ServerSendChunkSectionPacket element) {
            buffer.putInt(element.cx);
            buffer.putInt(element.cz);
            buffer.putInt(element.sy);
            buffer.put((byte)(element.isAllAir ? 1 : 0));
            if (!element.isAllAir) {
                for (short s : element.blocks) {
                    buffer.putShort(s);
                }
            }
        }

        @Override
        public ServerSendChunkSectionPacket deserialize(ByteBuffer buffer) {
            short[] blocks;
            boolean allAir;
            int cx = buffer.getInt();
            int cz = buffer.getInt();
            int sy = buffer.getInt();
            boolean bl = allAir = buffer.get() == 1;
            if (allAir) {
                blocks = null;
            } else {
                blocks = new short[4096];
                for (int i = 0; i < blocks.length; ++i) {
                    blocks[i] = buffer.getShort();
                }
            }
            return new ServerSendChunkSectionPacket(cx, cz, sy, blocks, allAir);
        }
    }
}

