/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.shared.net;

import de.hsw.mertcraft.shared.log.Log;
import de.hsw.mertcraft.shared.net.NetException;
import de.hsw.mertcraft.shared.net.NetParticipant;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedDeque;
import lombok.Generated;

public class NetConnection
implements NetParticipant {
    private final int writeBufferSize;
    private final ByteBuffer readBuf;
    private final ConcurrentLinkedDeque<ByteBuffer> outgoing = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedDeque<ByteBuffer> packets = new ConcurrentLinkedDeque();
    private InetAddress address;
    private final SocketChannel channel;
    private SelectionKey key;
    private int expectedSize = -1;

    public NetConnection(SocketChannel channel, int writeBufferSize, int readBufferSize) throws IOException {
        this.channel = channel;
        this.writeBufferSize = writeBufferSize;
        this.readBuf = ByteBuffer.allocate(readBufferSize);
        channel.configureBlocking(false);
    }

    public void attachKey(SelectionKey key) {
        this.key = key;
    }

    @Override
    public void update() throws IOException {
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public void flush() {
        try {
            while (!this.outgoing.isEmpty()) {
                ByteBuffer head = this.outgoing.peek();
                int n = this.channel.write(head);
                if (n < 0) {
                    throw new IOException("peer closed");
                }
                if (n == 0 || head.hasRemaining()) break;
                this.outgoing.poll();
            }
            if (this.outgoing.isEmpty()) {
                this.key.interestOps(this.key.interestOps() & 0xFFFFFFFB);
            }
        }
        catch (IOException e) {
            Log.error("NetConnection", "Error while writing", e);
        }
    }

    @Override
    public void send(ByteBuffer payload) {
        if (!this.isConnected()) {
            throw new NetException("Tried to send data but connection is closed!");
        }
        if (payload.position() > 0) {
            payload.flip();
        }
        if (payload.remaining() > this.writeBufferSize) {
            throw new NetException("Outgoing data exceeds write buffer size: " + payload.remaining() + " > " + this.writeBufferSize);
        }
        try {
            ByteBuffer packet = ByteBuffer.allocate(4 + payload.remaining());
            packet.putInt(payload.remaining());
            packet.put(payload);
            packet.flip();
            if (this.outgoing.isEmpty()) {
                int remain = this.channel.write(packet);
                if (remain < 0) {
                    Log.debug("NetConnection", "Unable to write because connection is closed!");
                    this.close();
                    return;
                }
                if (packet.hasRemaining()) {
                    this.outgoing.add(packet);
                    this.key.interestOps(this.key.interestOps() | 4);
                    this.key.selector().wakeup();
                }
            } else {
                this.outgoing.add(packet);
                this.key.interestOps(this.key.interestOps() | 4);
                this.key.selector().wakeup();
            }
        }
        catch (IOException e) {
            throw new NetException("Error sending data!", e);
        }
    }

    @Override
    public void readData() throws IOException {
        int read;
        if (!this.isConnected()) {
            return;
        }
        if (!this.readBuf.hasRemaining()) {
            this.readBuf.compact();
            if (!this.readBuf.hasRemaining()) {
                throw new NetException("Incoming data exceeds read buffer size: " + this.readBuf.capacity());
            }
        }
        if ((read = this.channel.read(this.readBuf)) == 0) {
            return;
        }
        if (read == -1) {
            this.close();
            return;
        }
        this.readBuf.flip();
        while (this.readBuf.hasRemaining()) {
            if (this.expectedSize == -1) {
                if (this.readBuf.remaining() < 4) break;
                this.expectedSize = this.readBuf.getInt();
                if (this.expectedSize <= 0 || this.expectedSize > this.readBuf.capacity()) {
                    throw new NetException("Incoming packet exceeds buffer size: " + this.expectedSize);
                }
            }
            if (this.readBuf.remaining() < this.expectedSize) break;
            int oldLimit = this.readBuf.limit();
            int endPos = this.readBuf.position() + this.expectedSize;
            this.readBuf.limit(endPos);
            ByteBuffer packetBuffer = ByteBuffer.allocate(this.expectedSize);
            packetBuffer.put(this.readBuf);
            packetBuffer.flip();
            this.packets.add(packetBuffer);
            this.readBuf.limit(oldLimit);
            this.expectedSize = -1;
        }
        this.readBuf.compact();
    }

    public ByteBuffer pollPacket() {
        return this.packets.poll();
    }

    public boolean hasPackets() {
        return !this.packets.isEmpty();
    }

    @Override
    public void close() throws IOException {
        if (this.channel.isConnected()) {
            this.channel.close();
        }
    }

    @Override
    public SocketAddress getAddress() {
        try {
            return this.channel.getRemoteAddress();
        }
        catch (IOException e) {
            throw new NetException("Error while retrieving remote address!", e);
        }
    }

    public String toString() {
        String addr = "unknown";
        try {
            SocketAddress a = this.channel.getRemoteAddress();
            addr = a != null ? a.toString() : "unknown";
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "NetConnection(" + addr + ")";
    }

    @Generated
    public SocketChannel getChannel() {
        return this.channel;
    }
}

