/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.shared.entity;

import de.hsw.mertcraft.shared.entity.EntityType;
import de.hsw.mertcraft.shared.serialize.BinaryIO;
import de.hsw.mertcraft.shared.serialize.ISerializer;
import de.hsw.mertcraft.shared.serialize.impl.StandardSerializers;
import java.nio.ByteBuffer;
import java.util.UUID;
import lombok.Generated;

public class Entity {
    private final EntityType type;
    private final UUID id;
    private float x;
    private float y;
    private float z;

    public void setPosition(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Generated
    public Entity(EntityType type, UUID id, float x, float y, float z) {
        this.type = type;
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Generated
    public EntityType getType() {
        return this.type;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public float getX() {
        return this.x;
    }

    @Generated
    public float getY() {
        return this.y;
    }

    @Generated
    public float getZ() {
        return this.z;
    }

    @Generated
    public void setX(float x) {
        this.x = x;
    }

    @Generated
    public void setY(float y) {
        this.y = y;
    }

    @Generated
    public void setZ(float z) {
        this.z = z;
    }

    public static final class Serializer
    implements ISerializer<Entity> {
        public static final Serializer instance = new Serializer();

        @Override
        public int getNecessarySize(Entity element) {
            return 1 + StandardSerializers.UUID.getNecessarySize(element.id) + 12;
        }

        @Override
        public void serialize(ByteBuffer buffer, Entity element) {
            buffer.put(BinaryIO.enumToByte(element.type));
            StandardSerializers.UUID.serialize(buffer, element.id);
            buffer.putFloat(element.x);
            buffer.putFloat(element.y);
            buffer.putFloat(element.z);
        }

        @Override
        public Entity deserialize(ByteBuffer buffer) {
            EntityType type = BinaryIO.fromOrdinal(EntityType.class, buffer.get());
            UUID id = StandardSerializers.UUID.deserialize(buffer);
            return new Entity(type, id, buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
        }
    }
}

