/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.ScreenUtils;
import de.hsw.mertcraft.MertCraft;
import de.hsw.mertcraft.screen.LoadingScreen;

public class MainMenuScreen
implements Screen {
    final Stage stage;
    final Skin skin;

    public MainMenuScreen() {
        this.stage = MertCraft.instance.stage;
        this.skin = MertCraft.instance.skin;
    }

    @Override
    public void show() {
        Table table = new Table(this.skin);
        table.setFillParent(true);
        MertCraft.instance.stage.addActor(table);
        table.background("dirt");
        Table content = new Table();
        table.add(content).grow();
        content.getColor().a = 0.0f;
        content.addAction(Actions.fadeIn(3.0f));
        Table titleTable = new Table();
        titleTable.add(new Image(new Texture("hsw.png"))).size(256.0f, 128.0f);
        titleTable.add(new Label("Craft", this.skin, "title"));
        content.add(titleTable).row();
        TextButton play = new TextButton("Play", this.skin);
        play.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MertCraft.instance.setScreen(new LoadingScreen());
            }
        });
        TextButton quit = new TextButton("Quit", this.skin);
        quit.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Gdx.app.exit();
            }
        });
        content.add(play).spaceBottom(10.0f).row();
        content.add(quit).row();
        Gdx.input.setInputProcessor(this.stage);
    }

    @Override
    public void render(float delta) {
        ScreenUtils.clear(Color.BLACK);
        this.stage.act();
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        this.stage.getActors().get(0).addAction(Actions.moveTo(0.0f, this.stage.getHeight(), 0.75f));
    }

    @Override
    public void dispose() {
    }

    private final class SettingsWindow
    extends Window {
        public SettingsWindow() {
            super("Settings", MainMenuScreen.this.skin);
            this.setModal(false);
            this.setMovable(false);
            float w = MainMenuScreen.this.stage.getWidth() * 0.8f;
            float h = MainMenuScreen.this.stage.getHeight() * 0.8f;
            this.setPosition(MainMenuScreen.this.stage.getWidth() * 0.5f - w * 0.5f, MainMenuScreen.this.stage.getHeight() * 0.5f - h * 0.5f);
            this.setSize(w, h);
            Label userName = new Label((CharSequence)"Username", MainMenuScreen.this.skin);
            this.add(userName).row();
            TextField name = new TextField("Crafter", MainMenuScreen.this.skin);
            this.add(name).row();
            TextButton save = new TextButton("Save", MainMenuScreen.this.skin);
            save.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    SettingsWindow.this.addAction(Actions.sequence((Action)Actions.fadeOut(1.0f), (Action)Actions.removeActor()));
                }
            });
            this.add(save).expand().bottom();
        }
    }
}

