/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.screen;

import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.ScreenUtils;
import de.hsw.mertcraft.MertCraft;
import de.hsw.mertcraft.game.GameSession;
import de.hsw.mertcraft.screen.MainMenuScreen;
import de.hsw.mertcraft.shared.log.Log;

public class LoadingScreen
implements Screen {
    private final Skin skin;
    private final Table table;
    private final Label loading;
    private boolean firstDraw;
    private boolean verified;
    float time;
    int dots;

    public LoadingScreen() {
        this.skin = MertCraft.instance.skin;
        this.table = new Table(this.skin);
        this.loading = new Label((CharSequence)"Loading", this.skin);
        this.firstDraw = true;
        this.time = 0.0f;
        this.dots = 0;
    }

    @Override
    public void show() {
        this.table.setFillParent(true);
        this.table.setBackground("dirt");
        this.table.add(this.loading);
        this.table.setPosition(0.0f, -MertCraft.instance.stage.getHeight());
        this.table.addAction(Actions.moveTo(0.0f, 0.0f, 0.75f));
        MertCraft.instance.stage.addActor(this.table);
    }

    private void startLoading() {
        try {
            boolean success = GameSession.startSession();
            if (!success) {
                MertCraft.instance.setScreen(new MainMenuScreen());
            }
        }
        catch (Exception e) {
            Log.error("LoadingScreen", "Error while loading", e);
            MertCraft.instance.setScreen(new MainMenuScreen());
        }
    }

    @Override
    public void render(float delta) {
        ScreenUtils.clear(Color.BLACK);
        this.time += delta;
        if (this.time >= 0.3f) {
            this.time = 0.0f;
            ++this.dots;
            if (this.dots == 4) {
                this.dots = 0;
            }
            String s = "Loading";
            for (int i = 0; i < this.dots; ++i) {
                s = s + ".";
            }
            this.loading.setText(s);
        }
        MertCraft.instance.stage.act();
        MertCraft.instance.stage.draw();
        if (this.firstDraw) {
            this.firstDraw = false;
            this.startLoading();
        } else {
            GameSession.getInstance().updateListener();
        }
    }

    @Override
    public void resize(int width, int height) {
        MertCraft.instance.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        this.table.addAction(Actions.sequence((Action)Actions.fadeOut(0.5f), (Action)Actions.removeActor()));
    }

    @Override
    public void dispose() {
    }
}

