/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.net;

import de.hsw.mertcraft.shared.log.Log;
import de.hsw.mertcraft.shared.net.NetConfig;
import de.hsw.mertcraft.shared.net.NetConnection;
import de.hsw.mertcraft.shared.net.NetException;
import de.hsw.mertcraft.shared.net.NetListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import lombok.Generated;

public class NetClient
extends NetConnection {
    private int maxPacketReads = 200;
    private final Selector selector;
    private volatile long connectTimer;
    volatile boolean running = true;
    private volatile boolean connected;
    private volatile boolean pendingConnect;
    private volatile boolean pendingDisconnect;
    private NetListener listener;

    public NetClient(int writeBufferSize, int readBufferSize) throws IOException {
        super(SocketChannel.open(), writeBufferSize, readBufferSize);
        SocketChannel channel = super.getChannel();
        channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        channel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
        this.selector = Selector.open();
    }

    public boolean connect(String host, int port) {
        try {
            if (this.isConnected()) {
                this.close();
            }
            this.getChannel().connect(new InetSocketAddress(host, port));
            SelectionKey key = this.getChannel().register(this.selector, 8);
            this.attachKey(key);
            this.connectTimer = System.currentTimeMillis() + NetConfig.CONNECTING_TIMEOUT;
            Log.info("NetClient", "Connecting...");
            Thread updater = new Thread(this::update, "client-net");
            updater.setDaemon(true);
            updater.start();
            return true;
        }
        catch (IOException e) {
            Log.error("NetClient", "Failed to connect to server", e);
            return false;
        }
    }

    public void updateListener() {
        ByteBuffer packet;
        if (this.listener == null) {
            return;
        }
        if (this.pendingDisconnect) {
            this.pendingDisconnect = false;
            this.listener.onDisconnect(this);
            return;
        }
        if (this.pendingConnect) {
            this.pendingConnect = false;
            this.listener.onConnect(this);
            return;
        }
        for (int reads = 0; reads <= this.maxPacketReads && (packet = this.pollPacket()) != null; ++reads) {
            this.listener.onReceive(this, packet);
        }
    }

    @Override
    public void update() {
        if (this.connected && this.running && !this.isConnected()) {
            this.close();
            return;
        }
        while (this.running) {
            try {
                this.selector.select();
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    it.remove();
                    if (!key.isValid()) continue;
                    if (this.connected) {
                        if (key.isReadable()) {
                            this.readData();
                        }
                        if (!key.isWritable()) continue;
                        this.flush();
                        continue;
                    }
                    if (!key.isConnectable()) continue;
                    this.handleConnect();
                    if (this.connected || System.currentTimeMillis() < this.connectTimer) continue;
                    Log.warn("NetClient", "Timeout while waiting to connect to server!");
                    key.cancel();
                    this.close();
                    return;
                }
            }
            catch (IOException e) {
                Log.error("NetClient", "An exception occurred while updating the client", e);
                this.close();
            }
        }
        if (this.connected) {
            this.close();
        }
    }

    public void handleConnect() throws IOException {
        if (!this.getChannel().isOpen()) {
            return;
        }
        if (!this.getChannel().finishConnect()) {
            throw new NetException("Connection not finished");
        }
        Log.info("NetClient", "Successfully connected!");
        this.connected = true;
        this.pendingConnect = true;
        SelectionKey key = this.getChannel().keyFor(this.selector);
        this.attachKey(key);
        key.interestOps(1);
    }

    @Override
    public void send(ByteBuffer payload) {
        if (!this.isReadyToSend()) {
            throw new NetException("Client isn't ready to send yet!");
        }
        super.send(payload);
    }

    @Override
    public void close() {
        try {
            this.running = false;
            this.pendingDisconnect = this.connected;
            this.connected = false;
            this.pendingConnect = false;
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isReadyToSend() {
        return this.isConnected() && this.connected;
    }

    public void registerListener(NetListener listener) {
        this.listener = listener;
    }

    public void removeListener() {
        this.listener = null;
    }

    @Generated
    public void setMaxPacketReads(int maxPacketReads) {
        this.maxPacketReads = maxPacketReads;
    }
}

