/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.io;

import de.hsw.mertcraft.game.GameSession;
import de.hsw.mertcraft.shared.net.packet.Services;
import de.hsw.mertcraft.shared.net.packet.client.ClientRequestChunkSectionPacket;
import de.hsw.mertcraft.shared.net.packet.server.ServerSendChunkSectionPacket;
import de.hsw.mertcraft.shared.net.rpc.DelayedResponse;
import java.util.ArrayDeque;
import lombok.Generated;

public class ChunkSectionLoader {
    private final ArrayDeque<Identifier> toLoad = new ArrayDeque();
    private DelayedResponse<ServerSendChunkSectionPacket> lastTask = null;
    private final GameSession session;

    public ChunkSectionLoader(GameSession session) {
        this.session = session;
    }

    public void update() {
        Identifier next;
        if (this.lastTask != null && !this.lastTask.isDone()) {
            return;
        }
        if (this.lastTask != null) {
            this.lastTask = null;
            this.toLoad.remove();
            if (this.toLoad.isEmpty()) {
                return;
            }
        }
        if ((next = this.toLoad.peek()) != null) {
            this.lastTask = this.session.execute(Services.PlayerRequestChunkService.class, new ClientRequestChunkSectionPacket(next.cx, next.cz, next.sy));
        }
    }

    public boolean load(int cx, int sy, int cz) {
        Identifier identifier = new Identifier(cx, cz, sy);
        if (this.toLoad.contains(identifier)) {
            return false;
        }
        this.toLoad.add(identifier);
        return true;
    }

    public boolean isFinished() {
        return this.toLoad.isEmpty();
    }

    private static final class Identifier {
        int cx;
        int cz;
        int sy;

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Identifier)) {
                return false;
            }
            return this.cx == ((Identifier)obj).cx && this.cz == ((Identifier)obj).cz && this.sy == ((Identifier)obj).sy;
        }

        @Generated
        public Identifier(int cx, int cz, int sy) {
            this.cx = cx;
            this.cz = cz;
            this.sy = sy;
        }

        @Generated
        public String toString() {
            return "ChunkSectionLoader.Identifier(cx=" + this.cx + ", cz=" + this.cz + ", sy=" + this.sy + ")";
        }
    }
}

