/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.io;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import de.hsw.mertcraft.shared.block.BlockRegistry;

public final class BlockRenderPalette {
    private static final Color WHITE = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private final FaceColors defaults = new FaceColors();
    private final ObjectMap<Short, FaceColors> byId = new ObjectMap();
    private final ObjectMap<String, FaceColors> byName = new ObjectMap();

    private BlockRenderPalette() {
    }

    public static BlockRenderPalette load(String jsonPath) {
        BlockRenderPalette p = new BlockRenderPalette();
        p.defaults.top.set(0.8f, 0.92f, 0.78f, 1.0f);
        p.defaults.north.set(0.62f, 0.49f, 0.34f, 1.0f);
        p.defaults.east.set(0.62f, 0.49f, 0.34f, 1.0f);
        p.defaults.south.set(0.62f, 0.49f, 0.34f, 1.0f);
        p.defaults.west.set(0.62f, 0.49f, 0.34f, 1.0f);
        p.defaults.bottom.set(0.55f, 0.55f, 0.55f, 1.0f);
        try {
            JsonValue ids;
            JsonValue blocks;
            JsonValue root = new JsonReader().parse(Gdx.files.internal(jsonPath));
            JsonValue def = root.get("defaults");
            if (def != null) {
                p.applyFaceColors(def, p.defaults);
            }
            if ((blocks = root.get("blocks")) != null) {
                JsonValue b = blocks.child;
                while (b != null) {
                    FaceColors fc = new FaceColors();
                    p.applyFaceColors(b, fc);
                    p.byName.put(b.name, fc);
                    b = b.next;
                }
            }
            if ((ids = root.get("byId")) != null) {
                JsonValue b = ids.child;
                while (b != null) {
                    short id = (short)Integer.parseInt(b.name);
                    FaceColors fc = new FaceColors();
                    p.applyFaceColors(b, fc);
                    p.byId.put(id, fc);
                    b = b.next;
                }
            }
        }
        catch (Throwable t) {
            Gdx.app.log("BlockRenderPalette", "Using defaults, failed to load " + jsonPath + ": " + t.getMessage());
        }
        return p;
    }

    private void applyFaceColors(JsonValue node, FaceColors into) {
        JsonValue all = node.get("all");
        if (all != null && all.size >= 3) {
            into.setAll(all.getFloat(0), all.getFloat(1), all.getFloat(2));
        }
        this.setIf(node, "top", into.top);
        this.setIf(node, "bottom", into.bottom);
        this.setIf(node, "north", into.north);
        this.setIf(node, "south", into.south);
        this.setIf(node, "west", into.west);
        this.setIf(node, "east", into.east);
        this.setIf(node, "side", into.north);
        this.setIf(node, "side", into.south);
        this.setIf(node, "side", into.west);
        this.setIf(node, "side", into.east);
    }

    private void setIf(JsonValue node, String key, Color c) {
        JsonValue v = node.get(key);
        if (v != null && v.size >= 3) {
            c.set(v.getFloat(0), v.getFloat(1), v.getFloat(2), 1.0f);
        }
    }

    public Color colorFor(short typeId, Face face) {
        FaceColors fc = this.byId.get(typeId);
        if (fc != null) {
            return fc.forFace(face);
        }
        String name = BlockRegistry.byId((short)typeId).name;
        fc = this.byName.get(name);
        if (fc != null) {
            return fc.forFace(face);
        }
        return this.defaults.forFace(face);
    }

    private static final class FaceColors {
        final Color top = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        final Color bottom = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        final Color north = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        final Color south = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        final Color west = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        final Color east = new Color(1.0f, 1.0f, 1.0f, 1.0f);

        private FaceColors() {
        }

        Color forFace(Face f) {
            switch (f) {
                case TOP: {
                    return this.top;
                }
                case BOTTOM: {
                    return this.bottom;
                }
                case NORTH: {
                    return this.north;
                }
                case SOUTH: {
                    return this.south;
                }
                case WEST: {
                    return this.west;
                }
            }
            return this.east;
        }

        void setAll(float r, float g, float b) {
            this.top.set(r, g, b, 1.0f);
            this.bottom.set(r, g, b, 1.0f);
            this.north.set(r, g, b, 1.0f);
            this.south.set(r, g, b, 1.0f);
            this.west.set(r, g, b, 1.0f);
            this.east.set(r, g, b, 1.0f);
        }

        void set(Face f, float r, float g, float b) {
            this.forFace(f).set(r, g, b, 1.0f);
        }
    }

    public static enum Face {
        TOP,
        BOTTOM,
        NORTH,
        SOUTH,
        WEST,
        EAST;

    }
}

