/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import de.hsw.mertcraft.game.GameSession;
import de.hsw.mertcraft.shared.entity.Player;
import de.hsw.mertcraft.shared.net.packet.Services;
import de.hsw.mertcraft.shared.net.packet.client.ClientMovePacket;
import de.hsw.mertcraft.shared.world.World;

public class PlayerController {
    private final Player player = GameSession.getInstance().getSelf();
    public final Vector3 vel = new Vector3();
    public float yaw = 180.0f;
    public float pitch = 0.0f;
    private final Vector3 half = new Vector3(0.3f, 0.9f, 0.3f);
    private final World world;
    private static final float GRAVITY = -20.0f;
    private static final float SPEED = 4.3f;
    private static final float SPRINT = 1.6f;
    private static final float JUMP = 8.0f;
    private boolean onGround = false;
    private final Vector3 oldPosition = new Vector3();
    private final Vector2 oldRot = new Vector2();

    public PlayerController(World world) {
        this.world = world;
        Gdx.input.setCursorCatched(true);
    }

    public void update(float dt, PerspectiveCamera cam) {
        this.oldPosition.set(this.player.getX(), this.player.getY(), this.player.getZ());
        this.oldRot.set(this.yaw, this.pitch);
        float sens = 0.15f;
        this.yaw -= (float)Gdx.input.getDeltaX() * sens;
        this.pitch -= (float)Gdx.input.getDeltaY() * sens;
        this.pitch = MathUtils.clamp(this.pitch, -89.0f, 89.0f);
        Vector3 fwd = new Vector3(-MathUtils.sinDeg(this.yaw), 0.0f, -MathUtils.cosDeg(this.yaw)).nor();
        Vector3 right = new Vector3(fwd.z, 0.0f, -fwd.x);
        Vector3 wish = new Vector3();
        if (Gdx.input.isKeyPressed(51)) {
            wish.add(fwd);
        }
        if (Gdx.input.isKeyPressed(47)) {
            wish.sub(fwd);
        }
        if (Gdx.input.isKeyPressed(32)) {
            wish.sub(right);
        }
        if (Gdx.input.isKeyPressed(29)) {
            wish.add(right);
        }
        if (wish.len2() > 0.0f) {
            wish.nor();
        }
        float speed = 4.3f * (Gdx.input.isKeyPressed(59) ? 1.6f : 1.0f);
        Vector3 target = new Vector3(wish).scl(speed);
        this.vel.x = MathUtils.lerp(this.vel.x, target.x, 0.18f);
        this.vel.z = MathUtils.lerp(this.vel.z, target.z, 0.18f);
        this.vel.y += -20.0f * dt;
        if (this.onGround && Gdx.input.isKeyJustPressed(62)) {
            this.vel.y = 8.0f;
            this.onGround = false;
        }
        this.moveAndCollide(dt);
        Vector3 forward = new Vector3(-MathUtils.sinDeg(this.yaw) * MathUtils.cosDeg(this.pitch), MathUtils.sinDeg(this.pitch), -MathUtils.cosDeg(this.yaw) * MathUtils.cosDeg(this.pitch)).nor();
        cam.position.set(this.player.getX(), this.player.getY() + 0.7f, this.player.getZ());
        cam.direction.set(forward);
        cam.up.set(Vector3.Y);
        cam.update();
        this.player.yaw = this.yaw;
        this.player.pitch = this.pitch;
        if (this.player.getX() != this.oldPosition.x || this.player.getY() != this.oldPosition.y || this.player.getZ() != this.oldPosition.z || this.yaw != this.oldRot.x || this.pitch != this.oldRot.y || this.vel.x != this.player.velX || this.vel.y != this.player.velY || this.vel.z != this.player.velZ) {
            GameSession.getInstance().execute(Services.PlayerMoveService.class, new ClientMovePacket(this.player.getId(), this.player.getX(), this.player.getY(), this.player.getZ(), this.yaw, this.pitch, this.vel.x, this.vel.y, this.vel.z));
        }
        this.player.velX = this.vel.x;
        this.player.velY = this.vel.y;
        this.player.velZ = this.vel.z;
    }

    private void moveAndCollide(float dt) {
        boolean falling;
        Vector3 old = new Vector3(this.player.getX(), this.player.getY(), this.player.getZ());
        Vector3 delta = new Vector3(this.vel).scl(dt);
        this.player.setX(this.player.getX() + delta.x);
        if (this.intersectsAny(this.half)) {
            this.player.setX(this.player.getX() + delta.x);
            this.player.setX(this.pushOut(old.x, delta.x, Axis.X));
            this.vel.x = 0.0f;
        }
        this.player.setY(this.player.getY() + delta.y);
        boolean bl = falling = this.vel.y < 0.0f;
        if (this.intersectsAny(this.half)) {
            this.player.setY(this.player.getY() + delta.y);
            this.player.setY(this.pushOut(old.y, delta.y, Axis.Y));
            if (falling) {
                this.onGround = true;
            }
            this.vel.y = 0.0f;
        } else {
            this.onGround = false;
        }
        this.player.setZ(this.player.getZ() + delta.z);
        if (this.intersectsAny(this.half)) {
            this.player.setZ(this.player.getZ() + delta.z);
            this.player.setZ(this.pushOut(old.z, delta.z, Axis.Z));
            this.vel.z = 0.0f;
        }
    }

    private float pushOut(float oldCoord, float delta, Axis axis) {
        int minX = MathUtils.floor(this.player.getX() - this.half.x);
        int maxX = MathUtils.floor(this.player.getX() + this.half.x);
        int minY = MathUtils.floor(this.player.getY() - this.half.y);
        int maxY = MathUtils.floor(this.player.getY() + this.half.y);
        int minZ = MathUtils.floor(this.player.getZ() - this.half.z);
        int maxZ = MathUtils.floor(this.player.getZ() + this.half.z);
        if (axis == Axis.X) {
            if (delta > 0.0f) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        for (int x = minX; x <= maxX; ++x) {
                            if (!this.world.isSolid(x, y, z)) continue;
                            return (float)x - this.half.x - 0.001f;
                        }
                    }
                }
            } else {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        for (int x = minX; x <= maxX; ++x) {
                            if (!this.world.isSolid(x, y, z)) continue;
                            return (float)(x + 1) + this.half.x + 0.001f;
                        }
                    }
                }
            }
        } else if (axis == Axis.Y) {
            if (delta > 0.0f) {
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        for (int y = minY; y <= maxY; ++y) {
                            if (!this.world.isSolid(x, y, z)) continue;
                            return (float)y - this.half.y - 0.001f;
                        }
                    }
                }
            } else {
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        for (int y = minY; y <= maxY; ++y) {
                            if (!this.world.isSolid(x, y, z)) continue;
                            return (float)(y + 1) + this.half.y + 0.001f;
                        }
                    }
                }
            }
        } else if (delta > 0.0f) {
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        if (!this.world.isSolid(x, y, z)) continue;
                        return (float)z - this.half.z - 0.001f;
                    }
                }
            }
        } else {
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        if (!this.world.isSolid(x, y, z)) continue;
                        return (float)(z + 1) + this.half.z + 0.001f;
                    }
                }
            }
        }
        return oldCoord;
    }

    private boolean intersectsAny(Vector3 h) {
        int minX = MathUtils.floor(this.player.getX() - h.x);
        int maxX = MathUtils.floor(this.player.getX() + h.x);
        int minY = MathUtils.floor(this.player.getY() - h.y);
        int maxY = MathUtils.floor(this.player.getY() + h.y);
        int minZ = MathUtils.floor(this.player.getZ() - h.z);
        int maxZ = MathUtils.floor(this.player.getZ() + h.z);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!this.world.isSolid(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static enum Axis {
        X,
        Y,
        Z;

    }
}

