/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.game;

import com.badlogic.gdx.Gdx;
import de.hsw.mertcraft.MertCraft;
import de.hsw.mertcraft.entity.VoxelPlayer;
import de.hsw.mertcraft.game.world.ClientWorld;
import de.hsw.mertcraft.io.Setting;
import de.hsw.mertcraft.net.rpc.RPCClient;
import de.hsw.mertcraft.screen.GameScreen;
import de.hsw.mertcraft.screen.MainMenuScreen;
import de.hsw.mertcraft.shared.entity.Player;
import de.hsw.mertcraft.shared.log.Log;
import de.hsw.mertcraft.shared.net.NetConnection;
import de.hsw.mertcraft.shared.net.NetListener;
import de.hsw.mertcraft.shared.net.packet.ChangeBlockPacket;
import de.hsw.mertcraft.shared.net.packet.Services;
import de.hsw.mertcraft.shared.net.packet.client.ClientInteractPacket;
import de.hsw.mertcraft.shared.net.packet.client.ClientJoinPacket;
import de.hsw.mertcraft.shared.net.packet.client.ClientMovePacket;
import de.hsw.mertcraft.shared.net.packet.server.ServerLoginPlayerPacket;
import de.hsw.mertcraft.shared.net.packet.server.ServerPlayerJoinedPacket;
import de.hsw.mertcraft.shared.net.packet.server.ServerPlayerQuitPacked;
import de.hsw.mertcraft.shared.net.packet.server.ServerSendChunkSectionPacket;
import de.hsw.mertcraft.shared.net.rpc.DelayedResponse;
import de.hsw.mertcraft.shared.net.rpc.RPCService;
import de.hsw.mertcraft.shared.world.Chunk;
import de.hsw.mertcraft.shared.world.ChunkSection;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

public class GameSession
extends RPCClient
implements NetListener {
    private final int SPAWN_CHUNK_RADIUS = 5;
    private static GameSession instance;
    private Player self;
    private ClientWorld world;
    private GameScreen view;
    private final int chunksPerFrame = 50;
    private final HashMap<Long, Integer> chunkRequestQueue = new HashMap();
    int send = 0;
    private DelayedResponse<ServerSendChunkSectionPacket> last = null;
    int count = 0;
    private final ArrayDeque<ByteBuffer> sendQueue = new ArrayDeque();
    private final List<Player> pendingJoins = new ArrayList<Player>();
    private boolean worldReady = false;

    public static boolean startSession() {
        if (instance != null) {
            instance.close();
        }
        try {
            instance = new GameSession();
            return instance.connect("87.106.78.201", 42069);
        }
        catch (IOException e) {
            Log.error("GameSession", "Failed to start session", e);
            return false;
        }
    }

    private GameSession() throws IOException {
        super(16384, 16384);
        this.registerListener(this);
        this.setupRPC();
    }

    private void setupRPC() {
        Services.register(this.rpcHandler);
        this.rpcHandler.setExecutor(Services.PlayerRequestJoinService.class, new RPCService.RemoteExecutor());
        this.rpcHandler.setAutoSubscription(Services.PlayerRequestJoinService.class, (value, valid) -> {
            this.enterWorld((ServerLoginPlayerPacket)value);
            int radius = 5;
            int cxCenter = Math.floorDiv((int)Math.floor(this.self.getX()), 16);
            int czCenter = Math.floorDiv((int)Math.floor(this.self.getZ()), 16);
            for (int dz = -radius; dz <= radius; ++dz) {
                for (int dx = -radius; dx <= radius; ++dx) {
                    int cx = cxCenter + dx;
                    int cz = czCenter + dz;
                    for (int y = 7; y >= 0; --y) {
                        this.getWorld().getSectionLoader().load(cx, y, cz);
                        ++this.send;
                    }
                }
            }
        });
        this.rpcHandler.setExecutor(Services.PlayerRequestChunkService.class, new RPCService.RemoteExecutor());
        this.rpcHandler.setAutoSubscription(Services.PlayerRequestChunkService.class, (value, valid) -> {
            Chunk chunk = this.world.getOrCreateChunk(value.cx, value.cz);
            ChunkSection section = chunk.getOrCreateSelection(value.sy);
            if (!value.isAllAir) {
                section.setData(value.blocks);
                this.view.getWorldRenderer().markDirtySection(chunk.cx, value.sy, chunk.cz);
            }
            ++this.count;
            if (this.count == this.send && MertCraft.instance.getScreen() != this.view) {
                MertCraft.instance.stage.clear();
                MertCraft.instance.setScreen(this.view);
            }
        });
        this.rpcHandler.setExecutor(Services.ServerPlayerJoinService.class, new RPCService.Executor<ServerPlayerJoinedPacket, Void>(){

            @Override
            public DelayedResponse<Void> invoke(NetConnection target, ServerPlayerJoinedPacket param) {
                if (!GameSession.this.worldReady || GameSession.this.world == null) {
                    GameSession.this.pendingJoins.add(param.player);
                    return null;
                }
                GameSession.this.world.addPlayer(param.player);
                ((GameSession)GameSession.this).view.renderPlayers.put(param.player, new VoxelPlayer("steve64.png"));
                return null;
            }
        });
        this.rpcHandler.setExecutor(Services.ServerPlayerQuitService.class, new RPCService.Executor<ServerPlayerQuitPacked, Void>(){

            @Override
            public DelayedResponse<Void> invoke(NetConnection target, ServerPlayerQuitPacked param) {
                ((GameSession)GameSession.this).view.renderPlayers.remove(GameSession.this.world.getPlayer(param.id)).dispose();
                GameSession.this.world.removePlayer(param.id);
                return null;
            }
        });
        this.rpcHandler.setExecutor(Services.PlayerMoveService.class, new RPCService.RemoteExecutor());
        this.rpcHandler.setExecutor(Services.ServerNotifyPlayerMovedService.class, new RPCService.Executor<ClientMovePacket, Void>(){

            @Override
            public DelayedResponse<Void> invoke(NetConnection target, ClientMovePacket param) {
                Player player = GameSession.this.getWorld().getPlayer(param.id);
                if (player == null) {
                    return null;
                }
                player.setPosition(param.x, param.y, param.z);
                player.yaw = param.yaw;
                player.pitch = param.pitch;
                player.velX = param.velX;
                player.velY = param.velY;
                player.velZ = param.velZ;
                return null;
            }
        });
        this.rpcHandler.setExecutor(Services.PlayerInteractService.class, new RPCService.RemoteExecutor());
        this.rpcHandler.setExecutor(Services.ServerNotifyPlayerInteractService.class, new RPCService.Executor<ClientInteractPacket, Void>(){

            @Override
            public DelayedResponse<Void> invoke(NetConnection target, ClientInteractPacket param) {
                Player player = GameSession.this.world.getPlayer(param.id);
                VoxelPlayer vp = ((GameSession)GameSession.this).view.renderPlayers.get(player);
                vp.getArmSwing().start(null);
                return null;
            }
        });
        this.rpcHandler.setExecutor(Services.PlayerChangeBlockService.class, new RPCService.RemoteExecutor());
        this.rpcHandler.setAutoSubscription(Services.PlayerChangeBlockService.class, (value, valid) -> {
            this.world.setBlock(value.x, value.y, value.z, value.block);
            this.view.getWorldRenderer().notifyChange(value.x, value.y, value.z);
        });
        this.rpcHandler.setExecutor(Services.ServerUpdateBlockService.class, new RPCService.Executor<ChangeBlockPacket, Void>(){

            @Override
            public DelayedResponse<Void> invoke(NetConnection target, ChangeBlockPacket param) {
                GameSession.this.world.setBlock(param.x, param.y, param.z, param.block);
                GameSession.this.view.getWorldRenderer().notifyChange(param.x, param.y, param.z);
                return null;
            }
        });
    }

    @Override
    public void send(ByteBuffer payload) {
        if (!this.isReadyToSend()) {
            this.sendQueue.add(payload);
            return;
        }
        super.send(payload);
    }

    public void enterWorld(ServerLoginPlayerPacket packet) {
        this.world = new ClientWorld(1334L);
        this.self = new Player(Setting.ID, Setting.USERNAME, packet.x, packet.y, packet.z);
        this.world.addPlayer(this.self);
        this.view = new GameScreen();
        for (Player p : this.pendingJoins) {
            this.world.addPlayer(p);
            this.view.renderPlayers.put(p, new VoxelPlayer("steve64.png"));
        }
        this.pendingJoins.clear();
        this.worldReady = true;
    }

    @Override
    public void updateListener() {
        super.updateListener();
        if (this.world != null) {
            this.world.update();
        }
    }

    @Override
    public void onConnect(NetConnection connection) {
        Log.info("GameSession", "Connected to server!");
        this.execute(Services.PlayerRequestJoinService.class, new ClientJoinPacket(Setting.ID, Setting.USERNAME));
    }

    @Override
    public void onDisconnect(NetConnection connection) {
        Log.info("GameSession", "Disconnected from server!");
    }

    @Override
    public void close() {
        super.close();
        Gdx.app.postRunnable(() -> MertCraft.instance.setScreen(new MainMenuScreen()));
        Log.info("GameSession", "Session closed!");
    }

    @Generated
    public static GameSession getInstance() {
        return instance;
    }

    @Generated
    public Player getSelf() {
        return this.self;
    }

    @Generated
    public ClientWorld getWorld() {
        return this.world;
    }

    @Generated
    public GameScreen getView() {
        return this.view;
    }
}

