/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.controll;

import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;
import de.hsw.mertcraft.shared.block.Block;
import de.hsw.mertcraft.shared.world.Chunk;
import de.hsw.mertcraft.shared.world.World;

public class GameCamera
extends PerspectiveCamera {
    private final World world;

    public GameCamera(float fieldOfViewY, float viewportWidth, float viewportHeight, World world) {
        super(fieldOfViewY, viewportWidth, viewportHeight);
        this.world = world;
    }

    public GameCamera(World world) {
        this.world = world;
    }

    private static float intBound(float s, float ds) {
        if (ds > 0.0f) {
            return ((float)MathUtils.floor(s + 1.0f) - s) / ds;
        }
        if (ds < 0.0f) {
            return (s - (float)MathUtils.floor(s)) / -ds;
        }
        return Float.POSITIVE_INFINITY;
    }

    public Hit raycastBlock(float maxDist) {
        Vector3 o = new Vector3(this.position);
        Vector3 d = new Vector3(this.direction).nor();
        int x = MathUtils.floor(o.x);
        int y = MathUtils.floor(o.y);
        int z = MathUtils.floor(o.z);
        int stepX = d.x > 0.0f ? 1 : -1;
        int stepY = d.y > 0.0f ? 1 : -1;
        int stepZ = d.z > 0.0f ? 1 : -1;
        float tMaxX = GameCamera.intBound(o.x, d.x);
        float tMaxY = GameCamera.intBound(o.y, d.y);
        float tMaxZ = GameCamera.intBound(o.z, d.z);
        float tDeltaX = (float)stepX / d.x;
        float tDeltaY = (float)stepY / d.y;
        float tDeltaZ = (float)stepZ / d.z;
        int px = x;
        int py = y;
        int pz = z;
        float t = 0.0f;
        while (t <= maxDist) {
            short b;
            Chunk column = this.world.getChunk(Math.floorDiv(x, 16), Math.floorDiv(z, 16));
            if (column != null && !Block.isAir(b = column.getBlock(x, y, z))) {
                Hit hit = new Hit();
                hit.bx = x;
                hit.by = y;
                hit.bz = z;
                hit.px = px;
                hit.py = py;
                hit.pz = pz;
                return hit;
            }
            px = x;
            py = y;
            pz = z;
            if (tMaxX < tMaxY) {
                if (tMaxX < tMaxZ) {
                    x += stepX;
                    t = tMaxX;
                    tMaxX += tDeltaX;
                    continue;
                }
                z += stepZ;
                t = tMaxZ;
                tMaxZ += tDeltaZ;
                continue;
            }
            if (tMaxY < tMaxZ) {
                y += stepY;
                t = tMaxY;
                tMaxY += tDeltaY;
                continue;
            }
            z += stepZ;
            t = tMaxZ;
            tMaxZ += tDeltaZ;
        }
        return null;
    }

    public static final class Hit {
        public int bx;
        public int by;
        public int bz;
        public int px;
        public int py;
        public int pz;
    }
}

